/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.renderer;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.entity.EntityCreatureTameable;
import com.lycanitesmobs.core.model.ModelCustom;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderCreature
extends RenderLiving<EntityCreatureBase> {
    private static final DynamicTexture textureBrightness = new DynamicTexture(16, 16);
    public static final float[][] colorTable = new float[][]{{1.0f, 1.0f, 1.0f}, {0.85f, 0.5f, 0.2f}, {0.7f, 0.3f, 0.85f}, {0.4f, 0.6f, 0.85f}, {0.9f, 0.9f, 0.2f}, {0.5f, 0.8f, 0.1f}, {0.95f, 0.5f, 0.65f}, {0.3f, 0.3f, 0.3f}, {0.6f, 0.6f, 0.6f}, {0.3f, 0.5f, 0.6f}, {0.5f, 0.25f, 0.7f}, {0.2f, 0.3f, 0.7f}, {0.4f, 0.3f, 0.2f}, {0.4f, 0.5f, 0.2f}, {0.6f, 0.2f, 0.2f}, {0.1f, 0.1f, 0.1f}};

    public RenderCreature(String entityID, RenderManager renderManager) {
        super(renderManager, AssetManager.getModel(entityID), 0.5f);
        if (this.field_77045_g instanceof ModelCustom) {
            ModelCustom modelCustom = (ModelCustom)this.field_77045_g;
            modelCustom.addCustomLayers(this);
        }
    }

    protected boolean bindEntityTexture(EntityCreatureBase entity) {
        ResourceLocation texture = this.getEntityTexture(entity);
        if (texture == null) {
            return false;
        }
        this.func_110776_a(texture);
        return true;
    }

    protected ResourceLocation getEntityTexture(EntityCreatureBase entity) {
        if (entity instanceof EntityCreatureBase) {
            return entity.getTexture();
        }
        return null;
    }

    protected void bindEquipmentTexture(Entity entity, String equipmentName) {
        this.func_110776_a(this.getEquipmentTexture(entity, equipmentName));
    }

    protected ResourceLocation getEquipmentTexture(Entity entity, String equipmentName) {
        if (entity instanceof EntityCreatureBase) {
            return ((EntityCreatureBase)entity).getEquipmentTexture(equipmentName);
        }
        return null;
    }

    protected void preRenderCallback(EntityCreatureBase entity, float particleTickTime) {
    }

    protected boolean canRenderName(EntityCreatureBase entity) {
        if (!Minecraft.func_71382_s()) {
            return false;
        }
        if (entity == this.field_76990_c.field_78734_h) {
            return false;
        }
        if (entity.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            return false;
        }
        if (entity.func_184179_bs() != null) {
            return false;
        }
        if (entity.func_94059_bO()) {
            if (entity instanceof EntityCreatureTameable && ((EntityCreatureTameable)entity).isTamed()) {
                return entity == this.field_76990_c.field_147941_i;
            }
            return true;
        }
        return entity.func_145818_k_() && entity == this.field_76990_c.field_147941_i;
    }

    public float func_77034_a(float par1, float par2, float par3) {
        float f3;
        for (f3 = par2 - par1; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return par1 + par3 * f3;
    }
}

